<?php
/**
 *       @file  qtrOptions.php
 *      @brief  This module contains implementation of _option method used to run code outside of WordPress
 *
 *     @author  Quttera (qtr), contactus@quttera.com
 *
 *   @internal
 *     Created  01/15/2016
 *    Compiler  gcc/g++
 *     Company  Quttera
 *   Copyright  Copyright (c) 2016, Quttera
 *
 * This source code is released for free distribution under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * =====================================================================================
 */

class CQtrOptions
{
    public static function Serialize($object){
        if(!function_exists('add_option') ){
            /* outside of WP */
            $output = json_encode($object);
            return $output;
        }else{
            /* inside WP */
            return serialize($object);
        }
    }


    public static function Unserialize($str){
        if(!function_exists('add_option') ){
            /* outside of WP */
            $output = json_decode($str,true);
            //echo "Serialize: ";
            //var_dump($output);
            return $output;
        }else{
            /* inside WP */
            return unserialize($str);
        }
    }

    public static function AddOption($option,$value, $deprecated, $autoload )
    {
        if(!function_exists('add_option') )
        {
            $file = fopen($option,"w") or die("Unable to open file!");
            fwrite($file, $value );
            fflush($file);
            fclose($file);
            return TRUE;
        }
        else
        {
            return add_option( $option,$value, $deprecated, $autoload );
        }
    }

    public static function GetOption($option,$default = false )
    {
        if(!function_exists('get_option') )
        {
            if(!is_file($option)){
                return $default;
            }
            $file = fopen( $option,"r+");
            fflush($file);
            $output = fread($file,filesize($option) + 10);
            fclose($file);
            return $output;
        }
        else
        {
            return get_option($option);
        }
    }


    public static function UpdateOption($option,$value)
    {
        if(!function_exists('update_option') )
        {
            return self::AddOption($option,$value,NULL,NULL);
        }
        else
        {
            return update_option($option,$value);
        }
    }

/*

if(!function_exists('add_option') )
{
    function add_option ( $option, $value = '', $deprecated = '', $autoload = true )
    {
        $file = fopen($option,"w") or die("Unable to open file!");
        fwrite($file, $value );
        fflush($file);
        fclose($file);
        return TRUE;
    }

    function get_option ( $option, $default = NULL )
    {
        if(!is_file($option)){
            return $default;
        }
        $file = fopen( $option,"r+");
        fflush($file);
        $output = fread($file,filesize($option) + 10);
        fclose($file);
        return $output;
    }

    function update_option( $option, $value, $autoload = true ){
        return add_option($option,$value,'',$autoload);

    }
 */

}

?>
