# Widget CSS Classes

Add custom classes and ids plus first, last, even, odd, and numbered classes to your widgets.

[![WordPress Plugin version](https://img.shields.io/wordpress/plugin/v/widget-css-classes.svg?style=flat)](https://wordpress.org/plugins/widget-css-classes/)
[![WordPress Plugin WP tested version](https://img.shields.io/wordpress/v/widget-css-classes.svg?style=flat)](https://wordpress.org/plugins/widget-css-classes/)
[![WordPress Plugin downloads](https://img.shields.io/wordpress/plugin/dt/widget-css-classes.svg?style=flat)](https://wordpress.org/plugins/widget-css-classes/)
[![WordPress Plugin rating](https://img.shields.io/wordpress/plugin/r/widget-css-classes.svg?style=flat)](https://wordpress.org/plugins/widget-css-classes/)
[![License](https://img.shields.io/badge/license-GPL--2.0%2B-green.svg)](https://github.com/cleverness/widget-css-classes/blob/master/license.txt)
[![Travis](https://secure.travis-ci.org/cleverness/widget-css-classes.png?branch=master)](http://travis-ci.org/cleverness/widget-css-classes)
[![Code Climate](https://codeclimate.com/github/cleverness/widget-css-classes/badges/gpa.svg)](https://codeclimate.com/github/cleverness/widget-css-classes)

### Widget CSS Classes gives you the ability to add custom classes and ids to your WordPress widgets

_Please note that this plugin doesn't enable you to enter custom CSS. You'll need to edit your theme's style.css or add another plugin that allows you to input custom CSS._

**This plugin also adds additional classes to widgets to help you style them easier:**

* widget-first: added to the first widget in a sidebar
* widget-last: added to the last widget in a sidebar
* widget-odd: added to odd numbered widgets in a sidebar
* widget-even: added to even numbered widgets in a sidebar
* widget-#: added to every widget, such as widget-1, widget-2

## Features

* Adds a text field to a widget for defining a class
* You can specify multiple classes by putting a space between them
* Optionally adds checkboxes with predefined classes
* Optionally adds a text field to add an id to a widget
* Adds first and last classes to the first and last widget instances in a sidebar
* Adds even/odd classes to widgets
* Adds number classes to widgets
* Fully translatable
* Multi-site compatible
* Compatible with Widget Logic, Widget Context, and WP Page Widget plugins
* Has filters and hooks for customizing output including class names

## Installation

1. Upload the folder _/widget-css-classes/_ to the _/wp-content/plugins/_ directory
2. Activate the plugin through the __Plugins__ menu in WordPress
3. Configure the settings under __Settings > Widget CSS Classes__
4. Visit __Appearance > Widgets__ to add or change the custom classes and ids for a widget.
5. Expand the appropriate widget in the desired sidebar.
6. You'll see a field labeled __CSS Class__. Depending on your settings, this will be a text field and/or checkboxes.
7. If you are using the text field you can enter multiple class names by separating them with a space.
8. If you've enabled the id field, you will see a text field called __CSS ID__.

## More info and documentation

[See our wiki!](https://github.com/cleverness/widget-css-classes/wiki)
