<?php
/*
 * Plugin Name: MWT Maintenance Mode
 * Plugin URI: http://modernwebtemplates.com
 * Description: Displays a maintenance page on frontend for anyone visitor who's not logged in.
 * Version: 1.0.1
 * Author: MWTemplates
 * Author URI: http://modernwebtemplates.com
 * License:  GPLv2 or later
*/

/**
 * Maintenance Page
 *
 * Displays the coming soon page for anyone who's not logged in.
 * The login page gets excluded so that you can login if necessary.
 *
 * @return void
 */

if ( ! function_exists( 'mwt_maintenance_mode' ) ) :
	function mwt_maintenance_mode() {
		global $pagenow;
		if ( $pagenow !== 'wp-login.php' && ! current_user_can( 'manage_options' ) && ! is_admin() ) {
			header( 'HTTP/1.1 Service Unavailable', true, 503 );
			header( 'Content-Type: text/html; charset=utf-8' );
			if ( file_exists( plugin_dir_path( __FILE__ ) . 'views/maintenance.php' ) ) {
				require_once( plugin_dir_path( __FILE__ ) . 'views/maintenance.php' );
			}
			die();
		}
	}
	add_action( 'wp_loaded', 'mwt_maintenance_mode' );
endif;